//
//  RootViewController.m
//  Presenting Master-Detail Views with UISplitViewController
//
//  Created by Vandad Nahavandipoor on 10/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "RootViewController.h"
#import "DetailViewController.h"
#import "Presenting_Master_Detail_Views_with_UISplitViewControllerAppDelegate.h"

@implementation RootViewController


- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
  self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
  if (self) {
    self.title = NSLocalizedString(@"Master", @"Master");
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad) {
      self.clearsSelectionOnViewWillAppear = NO;
      self.contentSizeForViewInPopover = CGSizeMake(320.0, 600.0);
    }
  }
  return self;
}

- (void)didReceiveMemoryWarning
{
  [super didReceiveMemoryWarning];
  // Usunięcie wszelkich buforowanych danych, obrazów itd., które nie są obecnie używane.
}

#pragma mark - Cykl życiowy widoku

- (void)viewDidLoad
{
  [super viewDidLoad];
	// Wszelka konfiguracja dodatkowa po wczytaniu widoku, najczęściej z pliku nib.
  if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad) {
    [self.tableView selectRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:0] animated:NO scrollPosition:UITableViewScrollPositionMiddle];
  }
}

- (void)viewDidUnload
{
  [super viewDidUnload];
  // Usunięcie wszystkich "przytrzymanych" podwidoków widoku głównego,
// na przykład self.myOutlet = nil;
}

- (void)viewWillAppear:(BOOL)animated
{
  [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
  [super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
  // Zwrot wartości YES dla obsługiwanych układów.
  if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
  } else {
    return YES;
  }
}

// Określenie liczby sekcji w widoku tabeli.
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
  return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
  return 1;
}

// Dostosowanie wyglądu komórki widoku tabeli.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
  static NSString *CellIdentifier = @"Cell";
  
  UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
  if (cell == nil) {
    cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier];
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
      cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    }
  }
  
  // Konfiguracja komórki.
  cell.textLabel.text = NSLocalizedString(@"Detail", @"Detail");
  return cell;
}

/*
 // Nadpisz metodę, aby zapewnić obsługę warunkowej edycji widoku tabeli.
 - (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath
 {
 // Wartość NO oznacza, że danego elementu nie można edytować.
 return YES;
 }
 */

/*
 // Nadpisz metodę, aby zapewnić obsługę edycji widoku tabeli.
 - (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
 {
 if (editingStyle == UITableViewCellEditingStyleDelete)
 {
 // Usunięcie rekordu ze źródła danych.
 [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
 }
 else if (editingStyle == UITableViewCellEditingStyleInsert)
 {
 // Utworzenie nowego egzemplarza odpowiedniej klasy, wstawienie do tablicy i dodanie nowego rekordu do widoku tabeli.
 }   
 }
 */

/*
 // Nadpisz metodę, aby zapewnić obsługę zmiany kolejności rekordów widoku tabeli.
 - (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath
 {
 }
 */

/*
 // Nadpisz metodę, aby zapewnić obsługę warunkowej zmiany kolejności rekordów widoku tabeli.
 - (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath
 {
 // Wartość NO oznacza, że nie można zmieniać kolejności danego elementu.
 return YES;
 }
 */

/* 1 */
//- (void)        tableView:(UITableView *)tableView 
//  didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
//  
//  if ([[UIDevice currentDevice] userInterfaceIdiom] 
//      == UIUserInterfaceIdiomPhone) {
//    
//    DetailViewController *detailViewController = 
//      [[DetailViewController alloc] 
//       initWithNibName:@"DetailViewController_iPhone" 
//                bundle:nil];
//    [self.navigationController pushViewController:detailViewController 
//                                         animated:YES];
//    
//  } else {
//    /* iPad */
//  }
//}

/* 2 */
- (void)        tableView:(UITableView *)tableView 
  didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
  
  if ([[UIDevice currentDevice] userInterfaceIdiom] 
      == UIUserInterfaceIdiomPhone) {
    
    DetailViewController *detailViewController = 
    [[DetailViewController alloc] 
     initWithNibName:@"DetailViewController_iPhone" 
     bundle:nil];
    [self.navigationController pushViewController:detailViewController 
                                         animated:YES];
    
  } else {
    /* iPad */
    
    Presenting_Master_Detail_Views_with_UISplitViewControllerAppDelegate
    *appDelegate = [[UIApplication sharedApplication] delegate];
    
    NSLog(@"%@", appDelegate.detailViewController);
    
  }
}

@end
